<?php
require_once("auth.php");
require_once("db_connect.php");

// -----------------------------------------------------------------------------
// Delete a book from the book database given its ISBN
// -----------------------------------------------------------------------------

// If "Delete" button as clicked check that an ISBN was entered.
// Othereise display the delete form so that an ISBN can be selected

if (isset($_REQUEST['delete'])) // delete button was clicked
{
   if ($_REQUEST['isbn'] == '')
   {
      display_form_page("ERROR: Please enter an ISBN");
   }
   else // if there is a book with this isbn delete it
   {
      $deleted = delete_book();
      if ($deleted)
      {
         $message = "Book has been deleted.";
      }
      else
      {
         $message = "No book found with this ISBN.";
      }
      display_response_page($message);
   }
}
else // delete button not pressed so display entry page
{
   display_form_page("");
}
?>

<?php

// -----------------------------------------------------------------------------
// Display page in response to a book deletion
// $message is a status messeage that the book was deleted or an error message
// -----------------------------------------------------------------------------

   function display_response_page($message)
   {
?>
   <html>
   <head><title>Delete Book</title></head>
   <body>
   <h1>Delete Book</h1>
   <h2><?php print $message?></h1>
   <?include("links.html");?>
   </body>
   </html>
<?php
}
?>

<?php

// -----------------------------------------------------------------------------
// Display rhe page showing the delete form.
// $message is a message such as an error message that is displayed
// -----------------------------------------------------------------------------

function display_form_page($message)
{
?>
<head><title>Delete Book</title></head>
<body>
<h1>Delete Book</h1>
<h2><?php print $message?></h2>
<form method = "POST">
<table border="1">
<tr><td>
<table border="0">
   <tr>
      <td>ISBN:</td>
      <td><input type = "text" name = "isbn"></td>
   </tr>

   <tr><td>&nbsp;</td>
      <td align="right"><input type = "submit" name = "delete" value = "Delete Book"></td>
   </tr>
</table>
</td></tr>
</table>
</form>
<?include("links.html");?>
</body>
</html>
<?php
}

// -----------------------------------------------------------------------------
// Use the DELETE query to delete book with specified ISBN from the database
// Returns true if the book was successfully deleted.
// Otherwise false is returned to indicate that no book was found with the
// specified ISBN.
// -----------------------------------------------------------------------------

function delete_book()
{
   $database = "bookstore";
   $table = "books";
   $db_link = db_connect($database);

   $isbn = addslashes($_REQUEST['isbn']);

   $query = "DELETE FROM $table WHERE isbn = '$isbn'";
   mysql_query($query);
   $rows = mysql_affected_rows();

   mysql_close($db_link);
   return $rows == 1 ;
}
?>
