<!DOCTYPE html>
<html>
<head>
  <title>Book-O-Rama Rezultati Pretrage</title>
</head>
<body>
  <h1>Book-O-Rama Rezultati Pretrage</h1>
  <?php
    // create short variable names
    $searchtype=$_POST['searchtype'];
    $searchterm=trim($_POST['searchterm']);
	

    if (!$searchtype || !$searchterm) {
       echo '<p>Nijeste unijeli podatke za pretragu.<br/>
       Vratite se nazad i pokusajte ponovo.</p>';
       exit;
    }
	
//	if (!get_magic_quotes_gpc())
//	{
//		$searchtype = addcslashes($searchtype);
//		$searchterm = addcslashes($searchterm);
//	}

    // whitelist the searchtype
    switch ($searchtype) {
      case 'Title':
      case 'Author':
      case 'ISBN':   
        break;
      default: 
        echo '<p>Ovo nije vazeci tip pretrage. <br/>
        Vratite se nazad i pokusajte ponovo.</p>';
        exit; 
    }

    $db = new mysqli('localhost', 'root', '', 'books');
    if (mysqli_connect_errno()) {
       echo '<p>Error: Nije moguce povezati se sa bazom podataka.<br/>
        Pokusajte ponovo kasnije.</p>';
       exit;
    }

    $query = "SELECT ISBN, Author, Title, Price FROM Books WHERE $searchtype = ?";
    $stmt = $db->prepare($query);
    $stmt->bind_param('s', $searchterm);  
    $stmt->execute();
    $stmt->store_result();
  
    $stmt->bind_result($isbn, $author, $title, $price);

    echo "<p>Broj nadjenih knjiga: ".$stmt->num_rows."</p>";

    while($stmt->fetch()) {
      echo "<p><strong>Naslov: ".$title."</strong>";
      echo "<br />Autor: ".$author;
      echo "<br />ISBN: ".$isbn;
      echo "<br />Cijena: \$".number_format($price,2)."</p>";
    }

    $stmt->free_result();
    $db->close();
  ?>
</body>
</html>
