<!DOCTYPE html>
<html>
<head>
  <title>Book-O-Rama Rezultati Pretrage</title>
</head>
<body>
  <h1>Book-O-Rama Rezultati Pretrage</h1>
  <?php
    // create short variable names
    $searchtype=$_POST['searchtype'];
    $searchterm="%{$_POST['searchterm']}%";

    if (!$searchtype || !$searchterm) {
       echo '<p>Nijeste unijeli podatke za pretragu.<br/>
       Vratite se nazad i pokusajte ponovo.</p>';
       exit;
    }


    // whitelist the searchtype
    switch ($searchtype) {
      case 'Title':
      case 'Author':
      case 'ISBN':   
        break;
      default: 
        echo '<p>Ovo nije vazeci tip pretrage. <br/>
        Vratite se nazad i pokusajte ponovo.</p>';
        exit; 
    }

    // set up for using PDO
    $user = 'root';
    $pass = '';
    $host = 'localhost';
    $db_name = 'books';

    // set up DSN
    $dsn = "mysql:host=$host;dbname=$db_name";

    // connect to database
    try {
      $db = new PDO($dsn, $user, $pass); 

      // perform query
      $query = "SELECT ISBN, Author, Title, Price FROM Books WHERE $searchtype like :searchterm";  
      $stmt = $db->prepare($query);  
      $stmt->bindParam(':searchterm', $searchterm);
      $stmt->execute(); 

      // get number of returned rows  
      echo "<p>Broj nadjenih knjiga: ".$stmt->rowCount()."</p>"; 

      // display each returned row
      while($result = $stmt->fetch(PDO::FETCH_OBJ)) {                                                       
        echo "<p><strong>Title: ".$result->Title."</strong>";                               
        echo "<br />Autor: ".$result->Author;                                              
        echo "<br />ISBN: ".$result->ISBN;                                                  
        echo "<br />Cijena: \$".number_format($result->Price, 2)."</p>";                                         
      }         

      // disconnect from database
      $db = NULL;
    } catch (PDOException $e) {
      echo "Error: ".$e->getMessage();
      exit;
    }
  ?>
</body>
</html>
