#include <stdio.h>
#include <stdlib.h>

// Napisati program koji racuna n-ti Fibonacijev broj
int fib(int n)
{
    // ova tehnika se zove top-down, jer krecemo od glavnog problema ka manjima
    if(n==0 || n==1)
    {
        return 1;
    }
    else
    {
        return fib(n-1)+fib(n-2);
    }
}
// Uradimo ovaj zadatak dinamickim programiranjem. U dinamickom programiranju razlikujemo dvije tehnike: tabulaciju i memoizaciju.
// Kod oba pristupa je sustina da se resenja potproblema cuvaju u memoriji.
int fibDin(int n)
{
    // ova tehnika je bottom-up (tabulacija)
    if(n==0 || n==1)
    {
        return 1;
    }

    int* fibNiz=malloc((n+1)*sizeof(int));
    fibNiz[0]=1;
    fibNiz[1]=1;

    int i;
    for(i=2 ; i<=n;i++)
    {
        fibNiz[i]=fibNiz[i-1]+fibNiz[i-2];
    }
    int rjesenje=fibNiz[n];
    free(fibNiz);
    return rjesenje;
}
// Data je matrica dimenzija mxn. Robot se nalazi na poziciji (0,0) i moze da se krece u dva pravca, desno i dolje.
// Robot treba da stigne do polja (x,y). Napisati f-ju minPut koja vraca cijenu najjeftinije putanje robota.
int minPut(int** mat, int m,int n,int x,int y)
{
    if(x==0 && y==0)
    {
        return mat[0][0];
    }
    if(x==0)
    {
        return mat[x][y]+minPut(mat,m,n,x,y-1);
    }
    if(y==0)
    {
        return mat[x][y]+minPut(mat,m,n,x-1,y);
    }
    int desno=minPut(mat,m,n,x,y-1);
    int dolje=minPut(mat,m,n,x-1,y);

    if(desno<dolje)
        return mat[x][y]+desno;
    else
        return mat[x][y]+dolje;
}

int minPutDin(int ** mat,int m,int n,int x,int y)
{
    // Treba nam pomocna matrica (mp) u kojoj cemo da cuvamo puteve
    // mp[i][j]=minPut(mat,m,n,i,j)
    int mp[100][100]; // treba dinamicka alokacija ali da ne gubimo vrijeme

    mp[0][0]=mat[0][0];

    int i,j;

    for(j=1;j<n;j++)
    {
        mp[0][j]=mp[0][j-1]+mat[0][j]; // do polja u prvoj vrsti moze se doci samo kretanjem na desno
    }

    for(i=1;i<m;i++)
    {
        mp[i][0]=mp[i-1][0]+mat[i][0]; // do polja u prvoj koloni moze se doci samo potezom prema dolje
    }

    for(i=1;i<m;i++)
    {
       for(j=1;j<n;j++)
       {
			/*Da bi nasli najnizu cijenu puta do polja (i, j), najprije nadjemo cijenu najeftinijih puteva
			  do polja (i, j-1) i (i-1, j) i na tu cijenu dodamo vrijednost iz matrice sa pozicije (i, j).
			  Element mp[i][j-1] sadrzi cijenu najjeftinije putanje do polja (i, j-1),
			  a element mp[i-1][j] sadrzi cijenu najjeftinije putanje do polja (i-1, j).
			  Do polja (i, j) se dolazi preko jednog od ova dva polja.*/
            if(mp[i][j-1]<mp[i-1][j])
            {
                mp[i][j]=mat[i][j]+mp[i][j-1];
            }
            else
            {
                 mp[i][j]=mat[i][j]+mp[i-1][j];
            }
       }
    }
    StampajminPut(mp,x,y);
    printf("\n");
    return mp[x][y];
}

// Na osnovu matrice puteva iz prethodnog zadatka odstampati najkracu putanju
void StampajminPut(int mp[][100],int x,int y)
{
    if(x==0 && y==0)
    {
        return;
    }
    if(x==0)
    {
        StampajminPut(mp,x,y-1);
        printf("Desno ");
        return;
    }
    if(y==0)
    {
        StampajminPut(mp,x-1,y);
        printf("Dolje ");
        return ;
    }

    if(mp[x][y-1]<mp[x-1][y])
    {
        StampajminPut(mp,x,y-1);
        printf("Desno ");
    }
    else
    {
        StampajminPut(mp,x-1,y);
        printf("Dolje ");
    }
}
/* Imamo n vrsta predmeta i svaki od tih n predmeta ima svoju zapreminu i vrijednost koji su predstavljeni cijelim brojevima.
   Te informacije cuvaju se u nizovima z i v duzine n. Imamo ranac cija je zapremina cio broj q. Naci najvecu mogucu vrijednost
   predmeta koji mogu da stanu u ranac. Za svaku vrstu postoji neogranicen broj predmeta tj. jednu istu vrstu predmeta
   mozemo dodavati u ranac proizvoljan broj puta.*/
int n;
int *z;
int *v;

void UcitajPodatke()
{
    FILE * f=fopen("knapsack.txt","r");

    if(f==NULL)
    {
        printf("Nije moguce otvoriti fajl.\n");
        return 0;
    }
    fscanf(f,"%d",&n);

    z=malloc(n*sizeof(int));
    v=malloc(n*sizeof(int));

    int i=0;
    for(i=0;i<n;i++)
    {
        fscanf(f,"%d",&(z[i]));
    }
    for(i=0;i<n;i++)
    {
        fscanf(f,"%d",&(v[i]));
    }
}

// Prvo cemo napisati rekurzivno rjesenje.
int KnapSack(int q) // jer su ostali globalne promjenljive
{
    if(q==0)
    {
        return 0;
    }
    int i=0;
    int max=0;
    for(i=0;i<n;i++) // prolazimo svih n predmeta
    {
        if(z[i]<=q) // da li predmet zapremine z[i] moze da stane u ranac
        {
            // dodamo predmet u ranac i pozovemo da se rekurzivno izracuna maksimalna vrijednost ranca zapremine q-z[i], jer toliko je jos ostalo prostora u rancu
            int temp=v[i]+KnapSack(q-z[i]);
            // na vrijednost koju nam vrati rekurzivni poziv dodamo vrijednost trenutnog predmeta v[i]
            if(temp>max)
            {
                max=temp;
            }
        }
    }
    return max;
}

// Rjesenje problema ranca tehnikom dinamickog programiranja. Koriscen je bottom-up pristup, tj. tabulacija
int KnapSackDin(int q)
{
    if(q==0)
        return 0;

    int* k=malloc((q+1)*sizeof(int)); // niz u kojem cuvamo maksimalnu vrijednost predmeta za ranac svih zapremina od 0 do q
    int* p=malloc((q+1)*sizeof(int)); // niz u kojima cuvamo indekse predmeta koje smo stavili u ranac da bi ih kasnije odstampali
    k[0]=0; // vriednost ranca zapremine 0
    p[0]=-1;
    int j;
    for(j=1;j<=q;j++) // racunamo redom maksimalne vrijednosi za ranceve, pocevsi od zapremine 1 pa dalje
    {
        int i=0;
        int max=0;
        p[j]=-1;
        for(i=0;i<n;i++)
        {
            if(z[i]<=j)
            {
                int temp=v[i]+k[j-z[i]];
                if(temp>max)
                {
                    max=temp;
                    p[j]=i; // oznacimo koji smo predmet dodali u ranac
                }
            }
        }
        k[j]=max;
    }

    int t=q;
    while(p[t]!=-1)
    {
        printf("%d ",p[t]);
        t=t-z[p[t]]; // vracamo se unazad za zapreminu predmeta koji smo iskoristili a njegova zapremina je z[p[t]] jer je p[t] indeks
    }
    printf("\n");
    int rezultat=k[q];
    free(k);
    return rezultat;
}
/* Rijesiti problem ranca gdje od svake vrste postoji samo po jedan predmet. Ovaj problem se naziva Knapsack01 problem.*/
/* Tehnika koja se ovdje koristi se naziva memoizacija. Memoizacija je top-down tehnika, isto kao i rekurzija.
   Kod veoma liči na rekurziju, ali nije identičan. Obratite pažnju.*/
int ks[1000];
int KnapSack01Din(int q, int n){
    if(q==0)
        return 0;

    if(ks[q]!=0){
        return ks[q];
    }
    else{
        ks[q]=0;
        // sada za svaku vrstu postoji samo jedan predmet te vrste i sa njim imamo dvije mogucnosti
        if(z[n-1]<=q){
            int x = KnapSack01Din(q-z[n-1],n-1); // 1. da dodamo taj predmet u ranac, ako moze da stane
            ks[q]=x+v[n-1];
        }

        int x = KnapSack01Din(q,n-1); // 2. da ne dodamo taj predmet u ranac
        if(x > ks[q])
            ks[q]=x;

        return ks[q];
    }
}
int main()
{
    /**printf("n-ti Fibonacijev broj je: %d\n",fib(45));**/ // Ovo ce da radi preko 30 sekundi
    printf("n-ti Fibonacijev btoj je: %d\n",fibDin(45));
    int a[]={1,8,9,5};
    int ** mat=NULL;
    int m,n;
    FILE * f=fopen("lavirint.txt","r");

    if(f==NULL)
    {
        printf("Nije moguce otvoriti fajl.\n");
        return 0;
    }
    fscanf(f,"%d %d",&m,&n);
    mat=malloc(m*sizeof(int*));
    int i=0;
    for(i=0;i<m;i++)
    {
        mat[i]=malloc(n*sizeof(int));
    }
    int j=0;

    for(i=0;i<m;i++)
    {
        for(j=0;j<n;j++)
        {
            fscanf(f,"%d",&(mat[i][j]));
        }
    }
    printf("Minimalan put je: %d\n",minPut(mat,m,n,3,3));
    printf("Minimalan put (dinamicki) je: %d\n",minPutDin(mat,m,n,3,3));
    UcitajPodatke();
    printf("Knapsack(5): %d\n",KnapSackDin(5));
    printf("Knapsack01(5): %d\n",KnapSack01Din(5,3));
    return 0;
}
