#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void displayBits(unsigned int value) {
    int c; /* counter */

    /* define displayMask and left shift 31 bits */
    unsigned int displayMask = 1 << 31;

    printf("%u = ", value);

    /* loop through bits */
    for (c = 1; c <= 32; c++) {

        if (value & displayMask)
            printf("1");
        else
            putchar('0');
        // moze i
        // putchar(value & displayMask ? '1' : '0');

        displayMask >>= 1;
        // moze i
        // value = value << 1; /* shift value left by 1 */

        if (c % 8 == 0) { /* output space after 8 bits */
            putchar(' ');
        } /* end if */

    } /* end for */

    putchar('\n');
} /* end function displayBits */

unsigned int str2set(char* s) {
    unsigned int skup = 0;
    int i = 0;
    while (s[i] != '\0') {
        int index = s[i] - 'a';
        int mask = (1 << index);
        skup = skup | mask;
        i++;
    }
    return skup;
}

int my_strspn(char* s1, char* s2) {
    unsigned int skup2 = str2set(s2);

    int cnt = 0;
    int i = 0;
    while (s1[i] != '\0') {
        unsigned int mask = (1 << (s1[i] - 'a'));
        if (mask & skup2) {
            cnt++;
            i++;
        }
        else {
            break;
        }
    }

    return cnt;
}

int my_strcspn(char* s1, char* s2) {
    unsigned int skup2 = str2set(s2);

    int cnt = 0;
    int i = 0;
    while (s1[i] != '\0') {
        unsigned int mask = (1 << (s1[i] - 'a'));
        if (mask & skup2) {
            break;
        }
        else {
            cnt++;
            i++;
        }
    }

    return cnt;
}

char* my_strpbrk(char* s1, char* s2) {
    unsigned int skup2 = str2set(s2);

    char* c_ptr = s1;
    while (*c_ptr != '\0') {
        unsigned int mask = (1 << (*c_ptr - 'a'));

        if (mask & skup2) {
            return c_ptr; // s1 + i ako bi isli sa brojacem i
        }

        c_ptr++;
    }

    return NULL;
}

/// za vjezbu - predstavljanje malih, velikih slova i cifara
/// koristiti unsigned long

int main()
{
    //unsigned int x = 1000;
    //displayBits(x);

    char* s1 = "abcdxyz";
    char* s2 = "abcdefg";
    printf("%d %d\n", strspn(s1, s2), my_strspn(s1, s2));

    char* s3 = "xyzabcd";
    char* s4 = "abcdefg";
    printf("%d %d\n", strcspn(s3, s4), my_strcspn(s3, s4));

    char* s5 = "abcdxyz";
    char* s6 = "wxyz";
    printf("%p %p\n", s5, strpbrk(s5, s6));
    printf("%p %p\n", s5, my_strpbrk(s5, s6));

    //unsigned int skup = str2set(s1);
    //displayBits(skup);

    return 0;
}
