#include <stdio.h>
#include <stdlib.h>

// Implementiran je max-heap
struct HeapRecord
{
    int * data;
    int size;
    int cap;
};
typedef struct HeapRecord Heap;

void initHeap(Heap* h,int cap)
{
    h->cap=cap;
    h->size=0;
    h->data=malloc(cap*sizeof(int));
}

void Delete(Heap* h)
{
    free(h->data);
}

int isEmpty(Heap* h)
{
    return h->size==0;
}

int isFull(Heap* h)
{
    return h->size==h->cap;
}

void insertHeap(Heap* h, int x)
{
    if(isFull(h))
    {
        printf("Heap je pun.\n");
        return;
    }
    int pos=h->size;
    h->data[pos]=x;

    while(pos>0){
        int fpos=(pos-1)/2;
        if(h->data[pos] > h->data[fpos]){ // ako je veci od oca
            int temp = h->data[pos];
            h->data[pos] = h->data[fpos];
            h->data[fpos] = temp;
            pos = fpos;
        }
        else
        {
            break;
        }
    }
    h->size++;
}
int deleteHeap(Heap* h) // uvijek brisemo korijen
{
    if(isEmpty(h))
    {
        printf("Heap je prazan.\n");
        return;
    }

    int temp = h->data[0];

    h->data[0] = h->data[--h->size];
    int pos = 0;
    while(pos < h->size){
        int son1 = 2*pos+1;
        int son2 = 2*pos+2;
        int biggerSon = son1;
        if(son2 < h->size && h->data[son2] > h->data[son1])
            biggerSon = son2;

        if(biggerSon < h->size && h->data[biggerSon] > h->data[pos]){
            int temp = h->data[pos];
            h->data[pos] = h->data[biggerSon];
            h->data[biggerSon] = temp;
            pos = biggerSon;
        }else{
            break;
        }
    }

    return temp;
}
int main()
{
    int a[] = {5, 12, 7, 2, 25, 13};
    Heap h;
    initHeap(&h, 100);
    int i;
    for(i=0;i<6;i++){
        insertHeap(&h, a[i]);
    }

    for(i=0;i<6;i++){
        printf("%d ",deleteHeap(&h));
    }
    return 0;
}
