import java.util.HashMap;

public class HashMapUvod {

	public static void main(String[] args) {
		// TODO Auto-generated method stub
		/* HashMap je struktura podataka u koju se smjestaju parovi kljuc-vrijednost. Elementima HashMap-e se pristupa preko kljuca. 
		 * Vrijednosti su objekti koje zelimo da mjestimo u ovu strukturu, dok su kljucevi najcesce stringovi ili brojevi, 
		 * ali ako je to potrebno mogu se i objekti drugih klasa koristiti kao kljucevi.
		 * Za to je potrebno da se redefinisu dva metoda koja data klasa naslijedi od klase Object:
		 * 		1. hashCode - metod koji vraca cjelobrojnu hash vrijednost objekta
		 * 		2. equals - metod kojim se provjerava da li su dva objekta klase jednaka
		 * Ova dva metoda su u klasama kao sto su String, Integer i Double vec definisana.
		 * HashMapu je najjednostavnije zamisliti kao beskonacni (veoma veliki) niz bucket-a. Zapravo je to niz koji se automatski povecava po unaprijed definisanom principu. 
		 * Svaki bucket je lista. Kada se novi par kljuc-vrijednost dodaje u HashMap-u prvo se racuna hashCode vrijednost za kljuc, 
		 * pa se data vrijednost smjesta u bucket (listu) koji odgovara tom hashCode-u. Zamislite hashCode kao indeks u tom velikom nizu listi.*/
		
		/* Sada je ocigledno da efikasnost pristupa elementima zavisi od funckije hashCode. Ako je ona definisana tako da npr. stalno vraca 0.
		 * public int hashCode(){
		 * 		return 0;
		 * }
		 * Onda ce svi kljucevi imati isti hashCode i sve vrijednosti bice smjestene u isti bucket (listu). 
		 * Ovo je najnepozeljnija situacija, jer je pristup elementu HashMap-e, kao i dodavanje novog slozenosti O(n).
		 * Najbolje je kada svi kljucevi imaju razlicit hashCode tada mozemo ocekivati da je slozenost pristupa i dodavanja novog elementa O(1).
		 * HashMapa moze biti veoma efikasna i korisna struktura podataka, ali samo pod uslovom da je hashCode funkcija za kljuceve "dobro definisana".*/
		
		// HashMap-a ciji su kljucevi stringovi, a vrijednosti su takodje stringovi
		HashMap<String, String> capitalCities = new HashMap<String, String>();

	    // Add keys and values (Country, City)
	    capitalCities.put("England", "London"); // funkcija put se koristi za dodavanje novog elementa u HashMap-u
	    capitalCities.put("Germany", "Berlin");
	    capitalCities.put("Norway", "Oslo");
	    capitalCities.put("USA", "Washington DC");
	    
	    System.out.println(capitalCities);
	    
	    System.out.println(capitalCities.get("England")); // Funkcija get za pristupanje elementu (jedini argument koji se koristi je kljuc).
	    
	    System.out.println(capitalCities.values()); // funkcija vraca sve vrijednosti iz HashMap-e
		
	    System.out.println(capitalCities.keySet()); // funkcija vraca sve kljuceve iz HashMap-e
		
	    System.out.println("England".hashCode());
	    System.out.println("Germany".hashCode());
	    
		// Ovo je HashMap-a ciji kljucevi su objekti klase Student, a vrijednosti su cijeli brojevi.
		HashMap<Student, Integer> m2 = new HashMap<Student, Integer>();
		
		Student s1 = new Student("Marko", 5);
		Student s2 = new Student("Marija", 2);
		
		m2.put(s1, 10);
		m2.put(s2, 9);
		
		Student s3 = new Student("Marko", 5);
		
		System.out.println(m2.get(s3));
		
		for(Student k: m2.keySet()){ // prolazak skupom kljuceva (isto se moze uraditi i za values)
			System.out.println(k);
		}
		
		//postoji i TreeMap kod kojeg bucket-i nijesu liste nego stabla,
		//pa se najgori moguci slucaj trazenja svodi na O(logn) - dodatak Java 8
		
		
	}

}
