import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Stack;


public class PosudeSaVodom {
	/*
	 * Date su dvije posude zapremine A i B litara i voda sa cesme u neogranicenoj kolicini. 
	 * Napisati funkciju water(int a, int b, int c) koja racuna najmanji broj poteza potreban da se izmeri tacno C litara vode koristeci date posude. 
	 * Ukoliko je nemoguce izmjeriti tacno C litara, vratiti -1. Ukoliko je moguce, pored broja poteza, odstampati i poteze.
	 * Dozvoljeni potezi su: punjenje jedne od dvije posude i presipanje iz jedne u drugu posudu sve dok se jedna od posuda ne napuni ili dok se jedna od posuda ne isprazni. 
	 * Na posudama nema oznaka za mjerenje manjih zapremina.
	 * Na primjer za A=5, B=3 i C=4 najmanji broj poteza je 6.
	 * */
	
	public static void printPath(Stanje curr, HashMap<Stanje,Stanje> prev){
		/* Da bi odstampali putanju koristimo HashMap-u prev. Pocinjemo od krajnjeg stanja i vracamo se unazad do pocetnog. 
		 * Sva stanja kroz koja prolazimo smjestamo na stek, jer idemo unazad, pa ce nam stanja kad ih budemo vadili sa steka biti u pravilnom redosljedu.*/
		Stack<Stanje> s = new Stack<Stanje>();
		
		s.push(curr);
		while(prev.get(curr).a!=-1){	
			curr = prev.get(curr);
			s.push(curr);
		}
		
		while(!s.isEmpty()){
			System.out.println(s.pop());
		}
	}
	public static int water(int a, int b, int c){
		/* Zadatak rjesavamo koriscenjem BFS procedure (skoro identicno kao problem sa skakacem). 
		 * Krecemo od stanja (0,0,0) i u svakom koraku u red za obilazak dodajemo stanja u koja mozemo doci iz trenutnog, a koja prethodno nijesmo obisli.*/
		Queue<Stanje> q = new LinkedList<Stanje>();
		HashMap<Stanje,Stanje> prev = new HashMap<Stanje, Stanje>(); // HashMap-u koristimo da bi znali iz kojeg stanja smo presli u koje. Ovo cemo kasnije koristiti da bi odstampali poteze.
		HashMap<Stanje,Boolean> visited= new HashMap<Stanje, Boolean>(); // HashMap-u koristimo i da bi vodili evidenciju koja smo stanja posjetili.
		
		Stanje start = new Stanje(0,0,0);
		q.add(start);
		visited.put(start,true);
		prev.put(start, new Stanje(-1,-1,-1));
		while(!q.isEmpty()){
			Stanje curr = q.poll();
			
			if(curr.a==c || curr.b==c){
				printPath(curr, prev);
				return curr.count;
			}
			Stanje next1 = new Stanje(curr.a,0,curr.count+1);
			Stanje next2 = new Stanje(0,curr.b,curr.count+1);
			Stanje next3 = new Stanje(a,curr.b,curr.count+1);
			Stanje next4 = new Stanje(curr.a,b,curr.count+1);
			Stanje next5 = new Stanje(Math.min(a, curr.a+curr.b), curr.b-Math.min(curr.b, a-curr.a), curr.count+1);
			Stanje next6 = new Stanje(curr.a-Math.min(curr.a, b-curr.b),Math.min(b, curr.b+curr.a), curr.count+1);
			
			if(!visited.containsKey(next1)){
				q.add(next1);
				visited.put(next1, true);
				prev.put(next1, curr);
			}
			
			if(!visited.containsKey(next2)){
				q.add(next2);
				visited.put(next2, true);
				prev.put(next2, curr);
			}
			
			if(!visited.containsKey(next3)){
				q.add(next3);
				visited.put(next3, true);
				prev.put(next3, curr);
			}
			
			if(!visited.containsKey(next4)){
				q.add(next4);
				visited.put(next4, true);
				prev.put(next4, curr);
			}
			
			if(!visited.containsKey(next5)){
				q.add(next5);
				visited.put(next5, true);
				prev.put(next5, curr);
			}
			
			if(!visited.containsKey(next6)){
				q.add(next6);
				visited.put(next6, true);
				prev.put(next6, curr);
			}
		}
		
		return -1;
	}
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		int a = 4;
		int b = 3;
		int c = 2;
		
		System.out.println(water(a,b,c));
		
		a = 5;
		b = 3;
		c = 4;
		System.out.println(water(a,b,c));
		
	}

}
