#include <iostream>
#include <list>

using namespace std;

struct node {
    int val;
    struct node* next;
};

void insert_it(struct node*& head, int v) {
    struct node* prev = NULL;
    struct node* curr = head;

    while (curr != NULL && curr->val <= v) {
        prev = curr;
        curr = curr->next;
    }

    struct node* new_node = new struct node;
    new_node->val = v;
    new_node->next = curr;

    if (prev == NULL) {
        head = new_node;
    }
    else {
        prev->next = new_node;
    }
}

void print_list(struct node* head) {
    while (head != NULL) {
        cout << head->val << " ";
        head = head->next;
    }
    cout << endl;
}

void print_list_r(struct node* head) {
    if (head == NULL) {
        cout << endl;
        return;
    }
    cout << head->val << " ";
    print_list_r(head->next);
}

void add_rear_r(struct node*& head, int v) {
    if (head == NULL) {
        struct node* new_node = new struct node;
        new_node->val = v;
        new_node->next = NULL;
        head = new_node;
        return;
    }
    add_rear_r(head->next, v);
}

void insert_r(struct node*& head, int v) {
    if (head == NULL || head->val > v) {
        struct node* new_node = new struct node;
        new_node->val = v;
        new_node->next = head;
        head = new_node;
        return;
    }
    insert_r(head->next, v);
}

void del_first_r(struct node*& head, int v) {
    if (head == NULL) {
        return;
    }
    if (head->val == v) {
        struct node* temp = head;
        head = head->next;
        delete temp;
        return;
    }
    del_first_r(head->next, v);
}

void del_all_r(struct node*& head, int v) {
    if (head == NULL) {
        return;
    }
    if (head->val == v) {
        struct node* temp = head;
        head = head->next;
        delete temp;
        del_all_r(head, v);
        return;
    }
    del_all_r(head->next, v);
}

/**
Nalazenje sredine liste
*/
int nadji_sredinu(struct node* head) {
    struct node* spori = head;
    struct node* brzi = head;

    while (brzi != NULL) {
        brzi = brzi->next;
        if (brzi != NULL) {
            brzi = brzi->next;
            spori = spori->next;
        }
    }

    return spori->val;
}

/**
6 7 3 10, x = 7
6 3 7 10
*/
void partition_l(struct node*& head, int x) {
    struct node* prev = NULL;
    struct node* curr = head;

    while (curr != NULL) {
        if (curr->val >= x || prev == NULL) {
            prev = curr;
            curr = curr->next;
        }
        else {
            prev->next = curr->next;
            curr->next = head;
            head = curr;
            curr = prev->next;
        }
    }
}

/**
2 1 5
5 5 0

2 7 4 3 5
7 0 5 5 0
*/
void prvi_veci(struct node* head) {
    struct node* curr_node = head;

    while (curr_node != NULL) {
        struct node* next_node = curr_node->next;
        while (next_node != NULL) {
            if (curr_node->val < next_node->val) {
                cout << next_node->val << " ";
                break;
            }
            next_node = next_node->next;
        }

        if (next_node == NULL) {
            cout << 0 << " ";
        }

        curr_node = curr_node->next;
    }

    cout << endl;
}

int main()
{
    struct node* head = NULL;
    insert_it(head, 7);
    insert_it(head, 2);
    insert_it(head, 14);
    insert_it(head, 5);
    print_list_r(head);

    insert_it(head, 6);
    print_list_r(head);

    add_rear_r(head, 20);
    print_list_r(head);

    insert_r(head, 15);
    insert_r(head, 1);
    print_list_r(head);

    del_first_r(head, 6);
    del_first_r(head, 1);
    del_first_r(head, 20);
    print_list_r(head);

    cout << nadji_sredinu(head) << endl;

    insert_r(head, 7);
    add_rear_r(head, 7);
    print_list_r(head);
    del_all_r(head, 7);
    print_list_r(head);

    cout << nadji_sredinu(head) << endl;

    struct node* head2 = NULL;
    // 11, 7, 3, 10, 6
    // 7, 3, 6, 10, 11
    add_rear_r(head2, 11);
    add_rear_r(head2, 7);
    add_rear_r(head2, 3);
    add_rear_r(head2, 6);
    add_rear_r(head2, 10);

    print_list_r(head2);
    prvi_veci(head2);

    partition_l(head2, 8);
    print_list_r(head2);

    cout << endl;

    list<int> l1;
    l1.push_back(6);
    l1.push_back(12);
    l1.push_front(3);
    l1.push_front(7);

    for (int x: l1) {
        cout << x << " ";
    }
    cout << endl;

    cout << l1.front() << endl;
    cout << l1.back() << endl;

    l1.pop_back();
    cout << l1.back() << endl;

    for (int x: l1) {
        x = x + 1;
    }
    for (int x: l1) {
        cout << x << " ";
    }
    cout << endl;

    list<int>::iterator it1;
    for (it1 = l1.begin(); it1 != l1.end(); it1++) {
        *it1 = *it1 + 1;
    }
    for (it1 = l1.begin(); it1 != l1.end(); it1++) {
        cout << *it1 << " ";
    }
    cout << endl;

    list<int>::reverse_iterator rit1;
    for (rit1 = l1.rbegin(); rit1 != l1.rend(); rit1++) {
        cout << *rit1 << " ";
    }
    cout << endl;

    list<int>::iterator it2;
    it2 = l1.begin();

    advance(it2, 2);
    l1.insert(it2, 10);
    //cout << *it2 << endl;
    l1.remove(7);
    for (int x: l1) {
        cout << x << " ";
    }
    cout << endl;

    // l1.erase()
    // l1.empty()
    // l1.size()

    return 0;
}
