#define TASTER 1
#define CONTINUOUS_START 5
#define WAKE_UP_END  6
#define WAKE_UP_BCR   4

//Trigger source determination
// Manual Trigger -                    RDC000
// Automatic induction trigger -       RDC010
// Uninterrupted continuous scanning - RDC020
// Single continuous automatic scan -  RDC030  - Software trigger
String comm[4]= {"RDC000;", "RDC010;", "RDC020;", "RDC030;"};

boolean taster, ptaster;
int bpt=0;

String barCode, message;
unsigned long bcrTriggered;
unsigned long TrigPeriod;

//Starovanje kontinualnog skeniranja
void continuousStart()
{
  pinMode(CONTINUOUS_START, OUTPUT);
  digitalWrite(CONTINUOUS_START, LOW);
  delay(50);
  digitalWrite(CONTINUOUS_START, HIGH);
  delay(50);
} 


//Funkcija za slanje komande čitaču i prihvatanje odgovora
int Command(String cmd){
  Serial.println(""); Serial.println(cmd);
  Serial1.print(cmd);
  
  while (!Serial1.available());
  while (Serial1.available()) {
    int c=Serial1.read();
    Serial.print(c);Serial.print(" ");    
    if(c==0x06){
      Serial.println("OK");
      return 1;
    }
  }
  Serial.println("Fail");
  return 0;
}

void setup() {
  // Initiate a serial communication with serial monitor
  Serial.begin(115200);
  Serial.setTimeout(100);
  Serial.println("START!!!");

  //Set up data direction
  pinMode(CONTINUOUS_START, INPUT);
  pinMode(TASTER, INPUT_PULLUP);
  pinMode(WAKE_UP_BCR, OUTPUT);
  pinMode(WAKE_UP_END, INPUT);

  // Initiate a serial communication with reader
  Serial1.begin(9600, SERIAL_8N1, 18, 17);
  Serial1.setTimeout(100);
 
  //WakeUp barcode reader
  Serial.println(F("Waking up barcode reader."));
  digitalWrite(WAKE_UP_BCR, LOW);
  digitalWrite(WAKE_UP_BCR, HIGH);
  while(!digitalRead(WAKE_UP_END));
  Serial.println(F("Barcode reader waked!!"));

  //Set Manual mode
  if(!Command(comm[0]))return;

  //Set Suffix to 0d 0a
  if(!Command("RDK020;"))return;  

  //Read taster
  taster=digitalRead(TASTER);
  ptaster=taster;
}

void loop() {
  //ispitivanje stanja tastera i izmjena moda rada čitača ukoliko se detektuje novi pritisak tastera


  //Prihvatanje i izvršavanje komande poslate putem serijskog monitora 



  //Prihvatanje podataka koje šalje čitač trakastoga koda
  if (Serial1.available()) {
    barCode = Serial1.readString();
  }

  if (barCode != "") {
    Serial.print(barCode);
    barCode = "";
  }
}
