from pdfminer.pdfinterp import PDFResourceManager, PDFPageInterpreter
from pdfminer.converter import PDFPageAggregator, XMLConverter
from pdfminer.layout import LAParams, LTTextBox, LTTextLine, LTChar, LTAnno
from pdfminer.pdfpage import PDFPage
from io import StringIO, BytesIO


def convert_pdf_to_xml(input_filename, output_filename):
    rsrcmgr = PDFResourceManager()
    retstr = BytesIO()
    laparams = LAParams()
    device = XMLConverter(rsrcmgr, retstr, codec="utf-8", laparams=laparams)
    fp = open(input_filename, 'rb')
    interpreter = PDFPageInterpreter(rsrcmgr, device)
    password = ""
    maxpages = 0
    caching = True
    pagenos = set()
    for page in PDFPage.get_pages(fp, pagenos, maxpages=maxpages, password=password, caching=caching, check_extractable=True):
        interpreter.process_page(page)

    fp.close()
    device.close()
    text = retstr.getvalue().decode()
    retstr.close()

    with open(output_filename, 'w', encoding="utf-8") as output_file:
        output_file.write(text)


def convert_pdf_to_json(input_filename):
    json_data = {"Pages": []}

    rsrcmgr = PDFResourceManager()
    retstr = StringIO()
    laparams = LAParams()
    # device1 = TextConverter(rsrcmgr, retstr, codec=codec, laparams=laparams)
    device = PDFPageAggregator(rsrcmgr, laparams=laparams)
    fp = open(input_filename, 'rb')
    interpreter = PDFPageInterpreter(rsrcmgr, device)
    password = ""
    maxpages = 0
    caching = True
    pagenos = set()

    for page in PDFPage.get_pages(fp, pagenos, maxpages=maxpages, password=password, caching=caching, check_extractable=True):
        interpreter.process_page(page)
        layout = device.get_result()

        blocks = parse_layout(layout)
        json_data["Pages"].append({"Blocks": blocks, "Region": {"X": layout.bbox[0],
                                                                "Y": layout.bbox[1],  # Y coordinates start from bottom to top, and this (X,Y) point is bottom-left point
                                                                "Width": layout.bbox[2]-layout.bbox[0],
                                                                "Height": layout.bbox[3]-layout.bbox[1]}})

    # text = retstr.getvalue()
    '''
    with open(output_filename, 'w', encoding="utf-8") as output_file:
        output_file.write(json.dumps(json_data, indent=4, ensure_ascii=False))
    '''
    fp.close()
    device.close()
    retstr.close()

    return json_data
    # return text


def parse_layout(layout):
    temp_bbox = [None for i in range(5)]
    temp = False
    result_list = []
    """Function to recursively parse the layout tree."""
    for lt_obj in layout:
        if (isinstance(lt_obj, LTChar) and lt_obj.get_text().isspace()) or isinstance(lt_obj, LTAnno):
            # LTAnno appears at the and of the string
            if temp is True:
                json_field = {"Original_text": temp_bbox[4],
                              "Region": {"X": temp_bbox[0],
                                         "Y": temp_bbox[1],
                                         "Width": temp_bbox[2]-temp_bbox[0],
                                         "Height": temp_bbox[3]-temp_bbox[1]}}
                result_list.append(json_field)
                temp = False
        elif isinstance(lt_obj, LTChar) and temp is False:
            temp = True
            temp_bbox[0] = lt_obj.bbox[0]
            temp_bbox[1] = lt_obj.bbox[1]
            temp_bbox[2] = lt_obj.bbox[2]
            temp_bbox[3] = lt_obj.bbox[3]
            temp_bbox[4] = str(lt_obj.get_text())
        elif isinstance(lt_obj, LTChar) and temp is True:
            temp_bbox[4] = temp_bbox[4]+str(lt_obj.get_text())
            temp_bbox[0] = min(temp_bbox[0], lt_obj.bbox[0])
            temp_bbox[1] = min(temp_bbox[1], lt_obj.bbox[1])
            temp_bbox[2] = max(temp_bbox[2], lt_obj.bbox[2])
            temp_bbox[3] = max(temp_bbox[3], lt_obj.bbox[3])
        elif isinstance(lt_obj, LTTextBox):
            temp = parse_layout(lt_obj)
            if temp:  # there are some cases where this is empty list
                json_field = {}
                json_field["Original_text"] = "\n".join(sentence["Original_text"] for sentence in temp)
                json_field["Sentences"] = temp
                json_field["Region"] = {"X": min([sentence["Region"]["X"] for sentence in temp]),
                                        "Y": min([sentence["Region"]["Y"] for sentence in temp]),
                                        "Width": max([sentence["Region"]["X"]+sentence["Region"]["Width"] for sentence in temp]) - min([sentence["Region"]["X"] for sentence in temp]),
                                        "Height": max([sentence["Region"]["Y"]+sentence["Region"]["Height"] for sentence in temp]) - min([sentence["Region"]["Y"] for sentence in temp]), }
            else:
                json_field = {"Original_text": lt_obj.get_text().strip(),
                              "Sentences": [],
                              "Region": {"X": lt_obj.bbox[0],
                                         "Y": lt_obj.bbox[1],
                                         "Width": lt_obj.bbox[2]-lt_obj.bbox[0],
                                         "Height": lt_obj.bbox[3]-lt_obj.bbox[1]}}

            result_list.append(json_field)
        elif isinstance(lt_obj, LTTextLine):
            temp = parse_layout(lt_obj)
            if temp:
                json_field = {}
                json_field["Original_text"] = " ".join(word["Original_text"] for word in temp)
                json_field["Words"] = temp
                json_field["Region"] = {"X": min([word["Region"]["X"] for word in temp]),
                                        "Y": min([word["Region"]["Y"] for word in temp]),
                                        "Width": max([word["Region"]["X"]+word["Region"]["Width"] for word in temp]) - min([word["Region"]["X"] for word in temp]),
                                        "Height": max([word["Region"]["Y"]+word["Region"]["Height"] for word in temp]) - min([word["Region"]["Y"] for word in temp]), }

            else:
                json_field = {"Original_text": lt_obj.get_text().strip(),
                              "Words": [],
                              "Region": {"X": lt_obj.bbox[0],
                                         "Y": lt_obj.bbox[1],
                                         "Width": lt_obj.bbox[2]-lt_obj.bbox[0],
                                         "Height": lt_obj.bbox[3]-lt_obj.bbox[1]}}

            result_list.append(json_field)

    return result_list
