#include <SoftwareSerial.h>

SoftwareSerial modemSerial(4, 7);      // RX, TX for ESP8266

#include <Adafruit_Sensor.h>
#include <DHT.h>
#include <DHT_U.h>
#define DHT11_PIN 2

#define READY  13

#define RESET 12
#define ATTEMPTS 3

#define CHECK_PERIOD 30000
#define LED_SIGNAL_PERIOD  300

#define DHTPIN 2     // Digital pin connected to the DHT sensor 
// Feather HUZZAH ESP8266 note: use pins 3, 4, 5, 12, 13 or 14 --
// Pin 15 can work but DHT must be disconnected during program upload.

// Uncomment the type of sensor in use:
#define DHTTYPE    DHT11     // DHT 11
//#define DHTTYPE    DHT22     // DHT 22 (AM2302)
//#define DHTTYPE    DHT21     // DHT 21 (AM2301)

// See guide for details on sensor wiring and usage:
//   https://learn.adafruit.com/dht/overview

DHT dht(DHTPIN, DHTTYPE);
float tempe, humid;


void(* resetFunc) (void) = 0;//declare reset function at address 0

bool DEBUG = true;   //show more logs
int responseTime = 10000; //communication timeout

String responses;
String channel;
String telNum = "+38267077344";
int indexInStr;

unsigned long pmillis, pled;
int pn = 0;


//Dobijanje informacije o temperaturi i vlazi sa senzora
void getTempHum(float* Temper, float* Humidit) {
  // Reading temperature or humidity takes about 250 milliseconds!
  // Sensor readings may also be up to 2 seconds 'old' (its a very slow sensor)
  float h = dht.readHumidity();
  // Read temperature as Celsius (the default)
  float t = dht.readTemperature();
  // Read temperature as Fahrenheit (isFahrenheit = true)
  float f = dht.readTemperature(true);

  // Check if any reads failed and exit early (to try again).
  if (isnan(h) || isnan(t) || isnan(f)) {
    Serial.println(F("Failed to read from DHT sensor!"));
    return;
  }

  // Compute heat index in Fahrenheit (the default)
  float hif = dht.computeHeatIndex(f, h);
  // Compute heat index in Celsius (isFahreheit = false)
  float hic = dht.computeHeatIndex(t, h, false);

  *Temper = t;
  *Humidit = h;
  Serial.print(F("Temperature: ")); Serial.print(*Temper); Serial.println(F("°C"));
  Serial.print(F("Humidity: ")); Serial.print(*Humidit); Serial.println(F("%"));
}


//Slanje SMS poruke o temperaturi i vlagi
void SendTempHumidSMS(String Number)
{
  getTempHum(&tempe, &humid);

  String thData = "Host room \r\n\r\nTemperature =" + String(tempe) + "*C\r\n" + "Humidity =" + String(humid) + "%RH";
  thData += (char)26; // ASCII kod od CTRL+Z
  Serial.println(thData);
  // SMS mesage sending
  if (sendToModem("AT+CMGS=\"" + Number + "\"\r\n", responseTime, ATTEMPTS, DEBUG, ">", responses) != 0) {
    digitalWrite(RESET, LOW);  // broj na koji šaljemo
    resetFunc();
  }
  modemSerial.println(thData); // SMS tekst koji zelimo da posaljemo
  if (sendToModem("", responseTime, ATTEMPTS, DEBUG, "OK", responses) != 0) {
    digitalWrite(RESET, LOW);
    resetFunc();
  }
}


//Inicijalizacija modema
void SetUpShield()
{
  if (sendToModem("AT", responseTime, ATTEMPTS, DEBUG, "OK", responses) != 0) {
    digitalWrite(RESET, LOW);
    resetFunc();
  }
  if (sendToModem("ATE1", responseTime, ATTEMPTS, DEBUG, "OK", responses) != 0) {
    digitalWrite(RESET, LOW);
    resetFunc();
  }
  if (sendToModem("AT+CREG?", responseTime, ATTEMPTS, DEBUG, "OK", responses) != 0) {
    digitalWrite(RESET, LOW);
    resetFunc();
  }
  if (sendToModem("AT+CMGF=1", responseTime, ATTEMPTS, DEBUG, "OK", responses) != 0) {
    digitalWrite(RESET, LOW);
    resetFunc();
  }
  if (sendToModem("AT+CNMI=2,2,0,0,0", responseTime, ATTEMPTS, DEBUG, "OK", responses) != 0) {
    digitalWrite(RESET, LOW);
    resetFunc();
  }
}


void setup()
{
  //Inicijalizacija pinova Arduino UNO razvojne ploce
  pinMode(RESET, OUTPUT);
  pinMode(READY, OUTPUT);
  digitalWrite(RESET, HIGH);
  digitalWrite(READY, LOW);

  // Open serial communications
  Serial.begin(9600);
  modemSerial.begin(9600);

  //Inicijalizacija modema
  Serial.println("Start!");
  SetUpShield();

  //Ciscenje buffera hardverskog seriala
  while (Serial.available() > 0) // Provjerava da li postoje podaci koji dolaze preko serijskog porta
    Serial.write(Serial.read());

  //Ciscenje buffera softverskog seriala
  while (modemSerial.available() > 0) // Provjerava da li postoje podaci koji dolaze preko serijskog porta
    Serial.write(modemSerial.read());

  //Signalizacija spremnosti uredjaja
  digitalWrite(READY, HIGH);
  Serial.println("Connection is running!");

  // Connect pin 1 (on the left) of the sensor to +5V
  // NOTE: If using a board with 3.3V logic like an Arduino Due connect pin 1
  // to 3.3V instead of 5V!
  // Connect pin 2 of the sensor to whatever your DHTPIN is
  // Connect pin 3 (on the right) of the sensor to GROUND (if your sensor has 3 pins)
  // Connect pin 4 (on the right) of the sensor to GROUND and leave the pin 3 EMPTY (if your sensor has 4 pins)
  // Connect a 10K resistor from pin 2 (data) to pin 1 (power) of the sensor

  // Initialize DHT sensor.
  // Note that older versions of this library took an optional third parameter to
  // tweak the timings for faster processors.  This parameter is no longer needed
  // as the current DHT reading algorithm adjusts itself to work on faster procs.
  dht.begin();
  getTempHum(&tempe, &humid);
}


void loop()
{
  if ( (millis() - pmillis) > CHECK_PERIOD) {
    if (sendToModem("AT", responseTime, ATTEMPTS, DEBUG, "OK", responses) != 0) {
      digitalWrite(RESET, LOW);  // provjera spremnosti modema
      resetFunc();
    }
    pmillis = millis();
  }
  if ( (millis() - pled) > LED_SIGNAL_PERIOD) {
    pled = millis();
    pn++;
    if (pn % 10)digitalWrite(READY, LOW);
    else digitalWrite(READY, HIGH);
  }

  if (Serial.available() > 0) {
    switch (Serial.read())
    {
      case 's': // Ako je ulaz 's' program ce pozvati f-ju za slanje SMS sa GSM modema
        SendTempHumidSMS(telNum);
        while (Serial.available() > 0) // Provjerava da li postoje podaci pristigli preko serijskog porta
          Serial.write(Serial.read());
        break;
    }
  }

  // Provjera da li postoje podaci koji dolaze preko softverskog serijala i prhihvat istih
  while (modemSerial.available() > 0) {
    Serial.write(modemSerial.read());
    delay(1);
  }
  delay(1);
}


/*
  Name: sendData
  Description: Function used to send string to tcp client using cipsend
  Params:
  Returns: void
*/
void sendData(String chn, String str) {
  String len = "";
  len += str.length();
  sendToModem("AT+CIPSEND=" + chn + "," + len, responseTime, ATTEMPTS, DEBUG, "OK", responses);
  delay(100);
  sendToModem(str, responseTime, ATTEMPTS, DEBUG, "OK", responses);
  delay(100);
  //sendToModem("AT+CIPCLOSE=5", responseTime, DEBUG);
}


/*
  Name: find
  Description: Function used to match two string
  Params:
  Returns: true if match else false
*/
boolean find(String string, String value) {
  if (string.indexOf(value) >= 0)
    return true;
  return false;
}


/*
  Name: readSerialMessage
  Description: Function used to read data from Arduino Serial.
  Params:
  Returns: The response from the Arduino (if there is a reponse)
*/
String  readSerialMessage() {
  char value[100];
  int index_count = 0;
  while (Serial.available() > 0) {
    value[index_count] = Serial.read();
    index_count++;
    value[index_count] = '\0'; // Null terminate the string
    delay(2);
  }
  String str(value);
  str.trim();
  return str;
}



/*
  Name: readmodemSerialMessage
  Description: Function used to read data from ESP8266 Serial.
  Params:
  Returns: The response from the esp8266 (if there is a reponse)
*/
String  readmodemSerialMessage() {
  char value[100];
  int index_count = 0;
  while (modemSerial.available() > 0) {
    value[index_count] = modemSerial.read();
    index_count++;
    value[index_count] = 'null'; // Null terminate the string
    if (value[index_count - 1] == '#')break;
    delay(2);
  }
  String str(value);
  str.trim();
  return str;
}



/*
  Name: sendToModem
  Description: Function used to send data to SIM900.
  Params: command - the data/command to send; timeout - the time to wait for a response; Attempts - number of attempts; debug - print to Serial window?(true = yes, false = no); rsp - expected answer; response - received answer
  Returns: The response from the SIM900 (if there is a reponse)
*/
int sendToModem(String command, const int timeout, int Attempts, boolean debug, String rsp, String response) {
  response = "";
  int rez = 1;
  int atmp = 0;
  while (atmp < Attempts)
  {
    if (debug)Serial.println(command);
    modemSerial.println(command); // send the read character to the SIM900
    long int time = millis();
    while ( (time + timeout) > millis())
    {
      if (modemSerial.available())
      {
        // The esp has data so display its output to the serial window
        char c = modemSerial.read(); // read the next character.
        response += c;
      }
      if (rsp != "")
      {
        if (find(response, rsp)) {
          rez = 0;
          break;
        }
      }
      else {
        rez = 0;
        break;
      }
    }
    if (debug)
    {
      Serial.println(response); Serial.println(rez);
    }
    if (!rez)break;
    atmp++;
  }
  return rez;
}

/*
  Name: sendToModem
  Description: Function used to send data to ESP8266.
  Params: command - the data/command to send; timeout - the time to wait for a response; debug - print to Serial window?(true = yes, false = no)
  Returns: The response from the esp8266 (if there is a reponse)
*/
String sendToUno(String command, const int timeout, boolean debug) {
  String response = "";
  Serial.println(command); // send the read character to the esp8266
  long int time = millis();
  while ( (time + timeout) > millis())
  {
    while (Serial.available())
    {
      // The esp has data so display its output to the serial window
      char c = Serial.read(); // read the next character.
      response += c;
      delay(2);
    }
    if (response != "")break;
  }
  if (debug)
  {
    Serial.println(response);
  }
  return response;
}
